VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSComm32.Ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Brewer UV Lamp Calibration Program V.3.4 By Ihab Abboud Aug. 2003"
   ClientHeight    =   7500
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   10725
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   500
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   715
   StartUpPosition =   2  'CenterScreen
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   10080
      Top             =   2520
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   18
      ImageHeight     =   12
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   2
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0442
            Key             =   "Blue"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmMain.frx":0745
            Key             =   "Red"
         EndProperty
      EndProperty
   End
   Begin VB.PictureBox Picture2 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   2775
      Left            =   0
      ScaleHeight     =   181
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   709
      TabIndex        =   4
      Top             =   3120
      Width           =   10695
      Begin VB.Frame Frame10 
         BackColor       =   &H8000000A&
         BorderStyle     =   0  'None
         Caption         =   "Frame6"
         Enabled         =   0   'False
         Height          =   510
         Left            =   6720
         TabIndex        =   5
         Top             =   2220
         Width           =   2745
         Begin MSComctlLib.ListView lsvLegend 
            Height          =   495
            Left            =   0
            TabIndex        =   6
            Top             =   0
            Width           =   2745
            _ExtentX        =   4842
            _ExtentY        =   873
            View            =   3
            LabelEdit       =   1
            LabelWrap       =   0   'False
            HideSelection   =   0   'False
            HideColumnHeaders=   -1  'True
            _Version        =   393217
            SmallIcons      =   "ImageList1"
            ForeColor       =   -2147483640
            BackColor       =   -2147483643
            BorderStyle     =   1
            Appearance      =   0
            BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
               Name            =   "Times New Roman"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            NumItems        =   2
            BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
               Text            =   "Colors"
               Object.Width           =   529
            EndProperty
            BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
               SubItemIndex    =   1
               Text            =   "Description"
               Object.Width           =   3881
            EndProperty
         End
      End
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "Turn &Lamp Off"
      Enabled         =   0   'False
      Height          =   495
      Left            =   0
      TabIndex        =   3
      Top             =   6600
      Width           =   10695
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BeginProperty Font 
         Name            =   "Courier"
         Size            =   9.75
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2655
      Left            =   0
      ScaleHeight     =   2595
      ScaleWidth      =   10635
      TabIndex        =   2
      Top             =   0
      Width           =   10695
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "&Turn Lamp On and Monitor"
      Height          =   495
      Left            =   0
      TabIndex        =   1
      Top             =   6000
      Width           =   10695
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   120
      Top             =   120
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      StopBits        =   2
   End
   Begin MSComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   0
      Top             =   7125
      Width           =   10725
      _ExtentX        =   18918
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   3
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   10980
            Text            =   "Status"
            TextSave        =   "Status"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   6
            AutoSize        =   2
            Object.Width           =   5292
            MinWidth        =   5292
            TextSave        =   "23/01/2012"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   5
            TextSave        =   "11:49 AM"
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuComm 
      Caption         =   "&Comm"
      Begin VB.Menu mnuComm1 
         Caption         =   "Comm1"
      End
      Begin VB.Menu mnuComm2 
         Caption         =   "Comm2"
      End
      Begin VB.Menu mnuComm3 
         Caption         =   "Comm3"
      End
      Begin VB.Menu mnuComm4 
         Caption         =   "Comm4"
      End
      Begin VB.Menu mnuOther 
         Caption         =   "Other"
      End
   End
   Begin VB.Menu mnuSystem 
      Caption         =   "&System"
      Begin VB.Menu mnuSetSystem 
         Caption         =   "S&et System"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'       Original Qbasic Version 1.0 Written by David Barton 1996
'       UVB Lamp Calibration Control Version 3.2
'       Rewritten to run On Windows Dec 2000 by Ihab Abboud
'       V 3.2.2 on Feb 16, 2001
'       Changed to V 3.3.1 on June 10,2002 to ReScale the graphing screen and to automate the file name
Const Millisec = 200
Dim cmd, Resp
Dim AvgVoltage As Single
Dim StdVoltage As Single
Dim mCurrent As Single
Dim Quit As Boolean
Dim RampInc As Single
Dim OutFile As String
Dim CalShuntVoltage As Single
Dim LampName As String
Dim DurationOfTime As String
Dim FirstTime As Boolean

Private Sub cmdQuit_Click()
    Response = MsgBox("Are you sure you want to quit ?", vbYesNo)
    If Response = vbYes Then
        Quit = True
        On Error Resume Next
        Open App.Path & "\Data\LampInfo.csv" For Input As #1
        Close #1
        If Error = "File not found" Then
            Open App.Path & "\Data\LampInfo.csv" For Output As #1
            Write #1, "Date", "Lamp", "Duration of Test"
            Write #1, Format(Date, "yyyy/mm/dd"), LampName, DurationOfTime
            Close #1
            Error = ""
        Else
            Open App.Path & "\Data\LampInfo.csv" For Append As #1
            Write #1, Format(Date, "yyyy/mm/dd"), LampName, DurationOfTime
            Close #1
        End If
    Else
        Exit Sub
    End If
End Sub

Private Sub cmdStart_Click()
    Dim DVMID As String
    Dim InstNumber As String
    Dim JD As Integer
    
    On Error Resume Next
    'Open Com
    MSComm1.PortOpen = True
    Sleep Millisec
    
    If Error <> "" Then
        MsgBox Error
        Exit Sub
    End If
    cmdStart.Enabled = False
    For k = 1 To 10
        MSComm1.Output = "SYST:REM" & Chr(13) & Chr(10) 'DVM in remote mode
        Sleep Millisec * 2
        MSComm1.Output = "*IDN?" & Chr(13) & Chr(10)
        Sleep Millisec * 2
        DVMID = MSComm1.Input
        Sleep Millisec * 2
        If Left(DVMID, 15) <> "HEWLETT-PACKARD" Then
            Picture1.Cls
            Picture1.Print "Trying to communicate..." & k
            DoEvents
            If k = 10 Then
                MSComm1.PortOpen = False
                MsgBox "Communication failure!" & vbCrLf & "Please check that the instruments are on and the correct Comm port is selected." & vbCrLf & "If all selections are correct, please try again !"
                cmdStart.Enabled = True
                Picture1.Cls
                Exit Sub
            End If
        Else
            Exit For
        End If
    Next
        
    Picture1.Print "Communicating successfully with DVM"
    Picture1.Print "Proceeding..."
    
    
    LampName = InputBox("Please Enter Lamp Name", "Lamp Name")
    While LampName = ""
        Resp = MsgBox("You either cancelled or didn't enter a name" _
                , vbRetryCancel, "Output File")
        If Resp = vbCancel Then End
        LampName = InputBox("Please Enter Lamp Name", "Lamp Name")
    Wend
    
    InstNumber = InputBox("Please Enter The Instrumnet's Number i.e. 071 ", "Instrument's Number", "071")
    While InstNumber = ""
        Resp = MsgBox("You either cancelled or didn't enter a file name." _
                , vbRetryCancel, "Instrument Number")
        If Resp = vbCancel Then End
        InstNumber = InputBox("Please Enter The Instrumnet's Number i.e. 071 ", "Instrument's Number", "071")
    Wend
    
    JD = jdayCalc(year(Now), month(Now), day(Now))
    OutFile = LampName & Format(JD, "000") & year(Now) & InstNumber & ".csv"
    
    MSComm1.Output = "*RST" & Chr(13) & Chr(10) 'reset the DVM
    Sleep Millisec
    MSComm1.Output = "GRST" & Chr(13)  'initialize the PS to is power on condition
    Sleep Millisec
    MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
    Sleep Millisec
    MSComm1.Output = "ADR 6" & Chr(13)
    Sleep Millisec
    MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
    Sleep Millisec
    MSComm1.Output = "OUT ON" & Chr(13)
    Sleep Millisec
    MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
    Sleep Millisec
    mCurrent = 0
    MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
    Sleep Millisec
        
    'Sets the supply's over protection trip point in Volts
    Call DVMVoltRead(1, 5)  ' read channel 1
    
    Picture1.Print "DVM Ch. 1 (Lamp Volt) : avg(5) " & Format(AvgVoltage, "0.000000") & "  std " & StdVoltage
    Call DVMVoltRead(2, 5)  ' read channel 2
    Picture1.Print "DVM Ch. 2 (Shunt Volt): avg(5) " & Format(AvgVoltage, "0.000000") & "  std " & StdVoltage
    
    Call Monitor(CalShuntVoltage)
End Sub

Private Sub Form_Activate()
    If TheFirstTime = False Then
        TheFirstTime = True
        Call Activate
    Else
        CalShuntVoltage = lVoltage
    End If
End Sub

Private Sub Activate()
    On Error Resume Next
    
    Dim FS As New FileSystemObject
    
    If FS.FolderExists(App.Path & "\Data") = False Then
        FS.CreateFolder (App.Path & "\Data")
    End If
    
    Open App.Path & "\LampCal.ini" For Input As #1
    Input #1, Temp, temp2
    Input #1, temp3, VOltage
    lVoltage = VOltage
    Close #1
    If lVoltage = 0 Then
        frmSystem.Show vbModal, Me
    End If
    
    MSComm1.CommPort = Val(temp2)
    If MSComm1.CommPort = 1 Then
        mnuComm1.Checked = True
    ElseIf MSComm1.CommPort = 2 Then
        mnuComm2.Checked = True
    ElseIf MSComm1.CommPort = 3 Then
        mnuComm3.Checked = True
    ElseIf MSComm1.CommPort = 4 Then
        mnuComm4.Checked = True
    Else
        mnuOther.Checked = True
    End If
    CalShuntVoltage = lVoltage
    
    Dim lItem As ListItem
    
    Set lItem = lsvLegend.ListItems.Add(, , , , "Blue")
    lItem.SubItems(1) = "Lamp Voltage"
    Set lItem = lsvLegend.ListItems.Add(, , , , "Red")
    lItem.SubItems(1) = "% Diff From Target Current"
    
    Picture2.CurrentX = 0
    Picture2.CurrentY = 0
    Picture2.Print "0.004 %"
    Picture2.CurrentY = Picture2.Height - 20
    Picture2.Print "-0.004 %"
    Picture2.CurrentY = Picture2.Height / 2 - (Picture2.Height / 2) / 4
    Picture2.Print "0.001 %"
    Picture2.CurrentY = Picture2.Height / 2 + (Picture2.Height / 2) / 4
    Picture2.Print "-0.001 %"
End Sub
Private Sub SaveData()
    Open App.Path & "\LampCal.ini" For Output As #1
    Write #1, "Comm", CStr(MSComm1.CommPort)
    Write #1, "CalShuntVoltage", CStr(CalShuntVoltage)
    Close #1
End Sub
Private Sub Form_Unload(Cancel As Integer)
    Dim Msg, Response   ' Declare variables.
    Msg = "If the lamp is on, data will be lost." & vbCrLf & "Do you still want to quit ?"
    Response = MsgBox(Msg, vbQuestion + vbYesNo)
    Select Case Response
        Case vbNo   ' Don't allow close.
            Cancel = -1
        Case vbYes
            Call SaveData
            Call RampDown
            End
    End Select
End Sub

Private Sub mnuComm1_Click()
    mnuComm1.Checked = True
    mnuComm2.Checked = False
    mnuComm3.Checked = False
    mnuComm4.Checked = False
    mnuOther.Checked = False
    MSComm1.CommPort = 1
End Sub

Private Sub mnuComm2_Click()
    mnuComm2.Checked = True
    mnuComm1.Checked = False
    mnuComm3.Checked = False
    mnuComm4.Checked = False
    mnuOther.Checked = False
    MSComm1.CommPort = 2
End Sub

Private Sub mnuComm3_Click()
    mnuComm1.Checked = False
    mnuComm2.Checked = False
    mnuComm3.Checked = True
    mnuComm4.Checked = False
    mnuOther.Checked = False
    MSComm1.CommPort = 3
End Sub

Private Sub mnuComm4_Click()
    mnuComm1.Checked = False
    mnuComm2.Checked = False
    mnuComm3.Checked = False
    mnuComm4.Checked = True
    mnuOther.Checked = False
    MSComm1.CommPort = 4
End Sub

Private Sub mnuFileExit_Click()
    'unload the form
    Unload Me

End Sub

Private Sub DVMVoltRead(channel, samples)


    If samples = 0 Then 'if no sample then quit
        Exit Sub
    End If

    'Range = 120 Volts, Resolution = 0.0001 Volts, Channel 1
    If (channel = 1) Then 'if using the 120V channel (Lamp voltage)
        MSComm1.Output = "CONF:VOLT:DC 120,0.0001,(@FRON1)" & Chr(13) & Chr(10)
        Sleep Millisec
    End If

    'Range = 10 Volts, Resolution = 0.00001 Volts, Channel 2
    If (channel = 2) Then 'if using the 10V channel (Shunt voltage)
        MSComm1.Output = "CONF:VOLT:DC 10,0.00001,(@FRON2)" & Chr(13) & Chr(10)
        Sleep Millisec
    End If

    'clear statistics variables
    StdVoltage = 0
    v = 0
    vv = 0
    For i = 1 To samples 'get the requested reading sample
        DoEvents
        MSComm1.Output = "READ?" & Chr(13) & Chr(10)
        Sleep 2 * Millisec
        Resp = MSComm1.Input
        Sleep Millisec
        VOltage = Val(Resp)
        v = v + VOltage
        vv = vv + VOltage * VOltage
    Next i

    'compute statistics
    AvgVoltage = v / samples
    If samples > 1 Then
        StdVoltage = Sqr(Abs((vv - v * v / samples) / (samples - 1)))
    End If
End Sub


Sub Monitor(CalShuntVoltage) 'control the lamp during calibration
    
    RampInc = 0.15 'current resolution for ramping the lamp current
    CurrentAdjustment = 0.002 'smallest current adjustment for monitor routine
    CalErrorVoltage = CalShuntVoltage * 0.000014 'deviance from calibration voltage
    
    
    MSComm1.Output = "PV 140" & Chr(13) & Chr(10) 'prepare the PS for current mode
    Sleep Millisec
    Open App.Path & "\Resistor.txt" For Input As #5
    Input #5, Temp, temp2
    Close #5
    mMaxCurrent = CSng(temp2) 'ramp up the current to 8 amps
    mnuComm.Enabled = False
    mnuSystem.Enabled = False
    While (mCurrent < mMaxCurrent)
        'DoEvents
        If (mCurrent + RampInc < mMaxCurrent) Then
            mCurrent = mCurrent + RampInc
        Else
            mCurrent = mMaxCurrent
        End If
        MSComm1.Output = "PC " & mCurrent & Chr(13)   'set new current on PS
        Sleep 2 * Millisec
    Wend
    
    MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
    Sleep 2 * Millisec
    
    Picture1.Cls
    Picture1.Print "Count", "Time", "CalShuntVolt", "ShuntVolt", "LampVolt", "Percent Difference"
    Picture2.Cls
    Quit = False
    FirstTime = True
    cmdQuit.Enabled = True
    cmdStart.Enabled = False
    
    xFactor = 0
    While Not Quit
        Picture2.DrawWidth = 1
        Picture2.Line (0, Picture2.Height / 2)-(Picture2.Width, Picture2.Height / 2)
        Picture2.Line (0, Picture2.Height / 2 - (Picture2.Height / 2) / 4)-(Picture2.Width, Picture2.Height / 2 - (Picture2.Height / 2) / 4)
        Picture2.Line (0, Picture2.Height / 2 + (Picture2.Height / 2) / 4)-(Picture2.Width, Picture2.Height / 2 + (Picture2.Height / 2) / 4)
        Picture2.DrawWidth = 3
        DoEvents
        
        Call DVMVoltRead(1, 5)  'read lamp channel and average 5 samples
        AvgLampVoltage = AvgVoltage
        StdLampVoltage = StdVoltage
    
        Call DVMVoltRead(2, 5)  ' read shunt channel and average 5 samples
        avgShuntVoltage = AvgVoltage
        StdShuntVoltage = StdVoltage
    
        diff = avgShuntVoltage - CalShuntVoltage
        If (Abs(diff) >= CalErrorVoltage) Then
            If (diff < 0) Then 'shunt voltage needs to be increased
                mCurrent = mCurrent + Abs(diff) * 1.5 * mMaxCurrent / lVoltage
            Else 'shunt voltage needs to be decreased
                mCurrent = mCurrent - Abs(diff) * 1.5 * mMaxCurrent / lVoltage
            End If
            MSComm1.Output = "PC " & mCurrent & Chr(13)  'set new current on PS
            Sleep Millisec
            
        End If
        MSComm1.Output = "*CLS" & Chr(13) & Chr(10) 'clear error
        Sleep Millisec
        kdur = kdur + 1
        If kdur = 10 * (Int(kdur) / 10) Then
            kdur = 0
            On Error Resume Next
            Open App.Path & "\Data\" & OutFile For Input As #2
            Close #2
            If Error = "File not found" Then
                Open App.Path & "\Data\" & OutFile For Append As #2
                PercentDiff = ((avgShuntVoltage - CalShuntVoltage) / CalShuntVoltage) * 100
                Write #2, "Date", "Time", "AvgLampVoltage", "CalShuntVoltage", "AvgShuntVoltage", "Percent Difference"
                Write #2, Format(Date, "yyyy/mm/dd"), Time$, Format(AvgLampVoltage, "0.0000"), CalShuntVoltage, Format(avgShuntVoltage, "0.000000"), Format(PercentDiff, "0.0000")
                
                Close #2
                Error = ""
            Else
                Open App.Path & "\Data\" & OutFile For Append As #2
                PercentDiff = ((avgShuntVoltage - CalShuntVoltage) / CalShuntVoltage) * 100
                Write #2, Format(Date, "yyyy/mm/dd"), Time$, Format(AvgLampVoltage, "0.0000"), CalShuntVoltage, Format(avgShuntVoltage, "0.000000"), Format(PercentDiff, "0.0000")
                Close #2
            End If
        End If
        i = i + 1
        j = j + 1
        
        If FirstTime Then
            StartHour = Hour(Now)
            StartMinute = Minute(Now)
            StartSecond = Second(Now)
            FirstTime = False
        End If
        
        Picture1.Print j, Time$, CalShuntVoltage, Format(avgShuntVoltage, "0.000000"), Format(AvgLampVoltage, "0.0000"), Format(PercentDiff, "0.0000") & "%"
        Picture2.PSet ((j - xFactor * 100) * Picture2.Width / 100, (Picture2.Height - Picture2.Height / 2) - (PercentDiff * Picture2.Height / 0.008)), QBColor(12)
        Picture2.CurrentX = 0
        Picture2.CurrentY = 0
        Picture2.Print "0.004 %"
        Picture2.CurrentY = Picture2.Height - 20
        Picture2.Print "-0.004 %"
        Picture2.CurrentY = Picture2.Height / 2 - (Picture2.Height / 2) / 4 - 5.7
        Picture2.Print "0.001 %"
        Picture2.CurrentY = Picture2.Height / 2 + (Picture2.Height / 2) / 4 - 5.5
        Picture2.Print "-0.001 %"
        If j = 20 Then
            imin = AvgLampVoltage - 0.25
            imax = AvgLampVoltage + 0.25
        ElseIf j > 20 Then
            If j / 100 = CInt(j / 100) Then
                imin = AvgLampVoltage - 0.25
                imax = AvgLampVoltage + 0.25
                xFactor = xFactor + 1
                Picture2.Cls
            End If
            Picture2.CurrentX = Picture2.Width - 50
            Picture2.CurrentY = 0
            Picture2.Print Format(imax, "0.00") & " V"
    
            Picture2.CurrentX = Picture2.Width - 50
            Picture2.CurrentY = Picture2.Height - 20
            Picture2.Print Format(imin, "0.00") & " V"
            Picture2.PSet ((j - xFactor * 100) * Picture2.Width / 100, Picture2.Height - ((AvgLampVoltage - imin) / (imax - imin) * Picture2.Height)), QBColor(9)
        End If
        DiffHour = Hour(Now) - StartHour
        DiffMinute = Minute(Now) - StartMinute
        DiffSecond = Second(Now) - StartSecond
        If DiffMinute < 0 Then
            DiffHour = DiffHour - 1
            DiffMinute = 60 + DiffMinute
        End If
        
        If DiffSecond < 0 Then
            DiffMinute = DiffMinute - 1
            DiffSecond = 60 + DiffSecond
        End If
        DurationOfTime = Format(DiffHour, "00") & ":" & Format(DiffMinute, "00") & ":" & Format(DiffSecond, "00")
        sbStatusBar.Panels.Item(1).Text = "Time Elapsed: " & DurationOfTime
        If i = 11 Then
            i = 0
            Picture1.Cls
            Picture1.Print "Count", "Time", "CalShuntVolt", "ShuntVolt", "LampVolt", "Percent Difference"
        End If
    Wend
    Call RampDown
    MSComm1.PortOpen = False
End Sub

Private Sub RampDown()
    On Error Resume Next
    Quit = False
    cmdQuit.Enabled = False
    While Not Quit
        mMinCurrent = 0 'ramp down the current to 0 amps
        While (mCurrent > mMinCurrent)
            'DoEvents
            If (mCurrent - RampInc > mMinCurrent) Then
                mCurrent = mCurrent - RampInc
            Else
                mCurrent = mMinCurrent
            End If
            MSComm1.Output = "PC " & mCurrent & vbCr 'Chr(13) 'set new current on PS
            Sleep Millisec  'time delay
        Wend
        MSComm1.Output = "PV 0" & Chr(13)  'the PS voltage is set to 0 volts
        Sleep Millisec
        mCurrent = 0 'force current = 0
        Quit = True 'time to quit
    Wend
    cmdStart.Enabled = True
    mnuComm.Enabled = True
    mnuSystem.Enabled = True
    
End Sub

Private Sub mnuOther_Click()
    Dim Response
    Response = InputBox("Enter The Comm. Port Number:")
    
    On Error Resume Next
    
    iResponce = CInt(Response)
    
    If Error <> "" Or iResponce <= 0 Then
        MsgBox (Response & " is not a valid comm. port number")
        Exit Sub
    End If
    
    MSComm1.CommPort = Response
    mnuComm1.Checked = False
    mnuComm2.Checked = False
    mnuComm3.Checked = False
    mnuComm4.Checked = False
    mnuOther.Checked = True
End Sub

Private Sub mnuSetSystem_Click()
    frmSystem.Show vbModal, Me
End Sub

Function jdayCalc(year, month, day) As Integer
'-----   Returns the julian day from day, month, year --------------------

  sumdays = 0
  i = 1                       ' COUNTER FOR CURRENT MONTH
  While i < month                     ' UNTIL CURRENT MONTH = SPECIFIED MONTH
    sumdays = sumdays + DinM(i, year) ' ADD DAYS IN CURRENT MONTH TO DAY COUNT
    i = i + 1                 ' INCREMENT MONTH
  Wend
  jdayCalc = sumdays + day    ' JULIAN DAY = DAY COUNT + DAYS IN SPECIFIED MONTH
End Function
  
Sub jdayUnCalc(jday As Integer, year As Integer, month As Integer, day As Integer)
'given year and julian day number, calculates month and day of month
  
  Dim i As Integer, j As Integer
 
  i = 1
  j = 31
  While jday > j
    i = i + 1
    k = j
    j = j + DinM(i, year)
  Wend
  month = i
  day = jday - j + DinM(i, year)
 
End Sub


Function DinM(month, year)
'-----   Calculates number of days in a month   --------------------------

  Select Case month
    Case 1, 3, 5, 7, 8, 10, 12
      DinM = 31                           ' 31 DAYS IN THESE MONTHS
    Case 4, 6, 9, 11
      DinM = 30                           ' 30 DAYS IN THESE MONTHS
    Case 2
      If year / 4 = Int(year / 4) Then    ' IT PROBABLY IS A LEAP YEAR
        If year / 100 <> Int(year / 100) Then    'not a century year
          DinM = 29                              ' FEBRUARY HAS 29 DAYS
        ElseIf year / 400 = Int(year / 400) Then 'century year divisible by 400
          DinM = 29
        Else                             ' OTHERWISE
          DinM = 28                         ' FEBRUARY HAS 28 DAYS
        End If
      Else
        DinM = 28
      End If
  End Select
End Function

